#include "door.h"
#include "main.h"

Door::Door() {}

Door::~Door() {}

void Door::init(Cell *c,bool exit) {
  this->c = c;
  this->exit = exit;
  this->angle = 0;
  this->speed = 0;

  c->putDoor(this);
}

void Door::update() {
  angle += speed;
  if (speed && angle==6) speed=0;
}

void Door::open() {
  if (!angle) speed=1;
}

bool Door::isOpenedExit() {
  return exit && angle>0;
}

void Door::render(float t) {

  float w=5*DOMWID;
  glColor3f(0.3f,0.6f,0.9f);
  glBegin(GL_QUADS);
  glNormal3f(0,0,1);
  /* left */
  glVertex3f(-w,     0,-3);
  glVertex3f(0.2f -w,0,-3);
  glVertex3f(0.2f -w,6.8f,-3);
  glVertex3f(-w,     6.8f,-3);
  /* top */
  glVertex3f(-w,6.8f,-3);
  glVertex3f( w,6.8f,-3);
  glVertex3f( w,7,-3);
  glVertex3f(-w,7,-3);
  /* right */
  glVertex3f(w-0.2f,   0,-3);
  glVertex3f(w,        0,-3);
  glVertex3f(w,     6.8f,-3);
  glVertex3f(w-0.2f,6.8f,-3);
  /* door */
  glEnd();

  glPushMatrix();
  glTranslatef(0.3f-w,0,-3);
  glRotatef((angle+t*speed)*15,0,1,0);
  glBegin(GL_QUADS);
  glNormal3f(0,0,1);
  glVertex3f(0,       0   ,0);
  glVertex3f(2*w-0.6f,0   ,0);
  glVertex3f(2*w-0.6f,6.7f,0);
  glVertex3f(0       ,6.7f,0);
  glEnd();
  glPopMatrix();
}

Cell *Door::getCell() {
  return c;
}
