#ifndef DOMINO_H
#define DOMINO_H

class Domino;

#include "cell.h"

class Domino {
 public:

  /* Say in which cell this should initially go. No need to call enter() */
  Domino();
  virtual void init(Cell *c);
  virtual ~Domino();

  /* t is a number between 0 and 1 indicating how far we are between
     two generations, 0 being the current generation and 1 being the
     next. When t reaches 1, update() is called and t resets to 1 */
  virtual void render(float t);

  /* Notify the camera that something interesting is happening over here */
  void lookAtMe(float t);

  /* The parameter t is used because this calls lookAtMe */
  bool renderBroken(float t);

/* Whether we are touching another domino in that direction */
  virtual bool touch(int direction);

  /* call this to have the player "grab" the domino (checks angle and
     speed, returns this if it is "grabbable", null otherwise */
  virtual Domino *grab();

  /** put this into that cell. Don't call c->enter(), this will deal
      with it */
  void enter(Cell *c);

  /* direction: what you want speed to be. Return value: true if
     we could get pushed (this function being the dual of touch(), in
     a way) */
  virtual bool push(int direction,int from);

  /* default push() calls push0() when domino is pushed out of
     vertical position */
  virtual bool push0(int direction);

  /* notify this domino that something fell over it. Most dominoes
     will break (default behavious) but splitter will split, instead */
  virtual void boom();

  virtual void update();

  // called by the default update() whenever the domino hits the floor
  virtual void land();

  /* When the trigger land()s, isDone() is called on everybody, and
     everybody has to reply true if the door is to be opened
     (otherwise the player lost) */
  virtual bool isDone();

 protected:
  // the angle at the previous generation, from -6 to +6
  int angle;

  // -1 is rotating to the left, 0 is still and +1 is rotating to the right
  int speed;

  // what the speed will be when update() is called
  int accel;

  // elevation, between -6 and +6 (-6 being one floor below and +6 one floor above)
  int elev;

  // as used by the cell methods. Always 0 for non-flyer dominoes, 1
  // for flyer dominoes once they took off
  int top;

  // whether it's moving vertically. +1 goes up, 0 doesn't move vertically and -1 goes down
  int fly;

  Cell *cell;

  bool broken;

  //  bool interesting; // whether this should be looked at

  /* does a glRotate according to current angle, speed and t (t as in render) */
  void rot(float t);

  /* dx should be -2, -1, 1 or 2 */
  Domino *neighbour(int dx,int top);

  void migrate (int dx,int dy);
};

#endif
