#ifndef DELAY_H
#define DELAY_H

class Delay;

#include "domino.h"

class Delay : public Domino {
 public:

  /* Say in which cell this should initially go. No need to call enter() */
  Delay();
  void init(Cell *c);
  ~Delay();

  /* t is a number between 0 and 1 indicating how far we are between
     two generations, 0 being the current generation and 1 being the
     next. When t reaches 1, update() is called and t resets to 1 */
  void render(float t);

  bool push0(int direction);
  void update();

 private:
  // when this is pushed, timer is set to some number (8?), and
  // decremented at each update(). When zero, accel is actually
  // transmitted to speed
  int timer;
};

#endif
