#include "delay.h"
#include "base.h"
#include "main.h"

Delay::Delay() {}

void Delay::init(Cell *c) {
  Domino::init(c);
  timer=0;
}

bool Delay::push0(int direction) {
  /* set the acceleration but don't move right away */
  accel=direction;
  if (timer==0)
    timer=8; // MAGIC NUMBER!
  return false; // block the advance of whoever pushed us
}

void Delay::update() {
  Domino::update();

  if (timer) {
    timer--;
    if (timer==0) {
      speed=accel;
      accel=0;
    }
  }
}

void Delay::render(float t) {
  /* handle push() here. We need this code twice because if it was a
     push() from vertical position, acceleration occurred after a delay,
     in update(). Has to be there because it may in turn push() the
     previous one. But if we are pushed() because an obstacle is gone,
     it happens instantly, maybe before our own update(), which is why it
     sets (accel) instead, which takes effect here */
  if (timer)
    lookAtMe(0);
  else if (accel) {
    speed=accel;
    accel=0;
  }

  glPushMatrix();

  rot(t);

  //    glEnable(GL_LIGHTING);

  if (renderBroken(t)) {

    glBegin(GL_QUADS);

    glNormal3f( 0,0, 1); // back
    glColor3f(1,1,0);
    glVertex3f(-DOMWID,0, 2);
    glVertex3f(-DOMWID,DOMHEI, 2);
    glVertex3f( DOMWID,DOMHEI, 2);
    glVertex3f( DOMWID,0, 2);

    glNormal3f( 0,0, -1); // front
    glColor3f(1,0,0);
    glVertex3f(-DOMWID,0, -2);
    glVertex3f(-DOMWID,DOMHEI, -2);
    glVertex3f( DOMWID,DOMHEI, -2);
    glVertex3f( DOMWID,0, -2);

    glNormal3f(0,1,0); // top right
    glVertex3f(0,DOMHEI,-2);
    glVertex3f(0,DOMHEI, 2);
    glVertex3f(DOMWID,DOMHEI, 2);
    glVertex3f(DOMWID,DOMHEI,-2);
    glColor3f(1,1,0); // top left
    glVertex3f(-DOMWID,DOMHEI,-2);
    glVertex3f(-DOMWID,DOMHEI, 2);
    glVertex3f(0,DOMHEI, 2);
    glVertex3f(0,DOMHEI,-2);

    glNormal3f(0,1,0); // bottom right
    glColor3f(1,1,0);
    glVertex3f(0,0,-2);
    glVertex3f(0,0, 2);
    glVertex3f(DOMWID,0, 2);
    glVertex3f(DOMWID,0,-2);
    glColor3f(1,0,0); // bottom left
    glVertex3f(-DOMWID,0,-2);
    glVertex3f(-DOMWID,0, 2);
    glVertex3f(0,0, 2);
    glVertex3f(0,0,-2);

    glEnd();

    glBegin(GL_TRIANGLES);
    glNormal3f(1,0,0); // right top
    glVertex3f(DOMWID,0,-2);
    glVertex3f(DOMWID,DOMHEI,-2);
    glVertex3f(DOMWID,DOMHEI,2);

    glNormal3f(-1,0,0);
    glVertex3f(-DOMWID,DOMHEI,2); // left bottom
    glVertex3f(-DOMWID,0,2);
    glVertex3f(-DOMWID,0,-2);

    glNormal3f(-1,0,0); // why do I need to call this again?
    glColor3f(1,1,0); // left top
    glVertex3f(-DOMWID,0,-2);
    glVertex3f(-DOMWID,DOMHEI,-2);
    glVertex3f(-DOMWID,DOMHEI,2);

    glNormal3f(1,0,0); // right bottom
    glVertex3f(DOMWID,DOMHEI,2);
    glVertex3f(DOMWID,0,2);
    glVertex3f(DOMWID,0,-2);
    glEnd();

  }

  glPopMatrix();
}

Delay::~Delay() {

}


