#ifndef CELL_H
#define CELL_H

class Cell;

/** A fixed position on the screen, that may contain a domino */

#include "domino.h"
#include "door.h"

class Cell {
 public:
  
  /* x and y are the coordinates on the screen */
  Cell();
  void init(int x,int y,int hasFloor,bool hasLadder);
  ~Cell();

  void render(float t);

  /** Put a domino in that cell (top=0:bottom, top=1:top). If there
      was one already, the domino is still put, but false is returned
      and both are boom()ed. */
  bool enter(Domino *d,int top);

  /** Remove whatever domino was in that cell (top=0:bottom, top=1:top) */
  void leave(int top);

  int getX();
  int getY();

  /* returns &blank if there's none (top=0:bottom, top=1:top) */
  Domino *getDomino(int top);

  // see description below
  int getFloor();

  bool getLadder();

  // used by exploders, bridgers, and friends
  void setFloor(int floor);

  void putDoor(Door *door);

  /* returns null if there's none */
  Door *getDoor();

 private:
  
  /* A single cell can contain at least two dominoes (twin splitter
     dominoes count as a single domino). Flyers that have been hit at
     least once live in top parts of cells, and others live in bottom parts. */
  Domino *d[2];
  Door *door;

  int x;
  int y;

  // 0 means none, 1 means a single block, 3 is connected to the left,
  // 5 is connected to the right and 7 is connected both directions
  // (yes, this is a bitfield)
  int hasFloor;

  bool hasLadder;
};

#endif
