#include "cell.h"
#include "main.h"

Cell::Cell() {}

void Cell::init(int x,int y,int hasFloor,bool hasLadder) {
  this->x = x;
  this->y = y;
  this->hasFloor = hasFloor;
  this->hasLadder = hasLadder;
  this->d[0] = 0;
  this->d[1] = 0;
  this->door = 0;
//   printf("new cell at (%d,%d),floor %d,ladder %d\n",getX(),getY(),getFloor(),getLadder());
}

Cell::~Cell() {
}

void Cell::render(float t) {
  getDomino(0)->render(t);
  getDomino(1)->render(t);
  if (door) door->render(t);

  if (hasFloor) {
    float l= -2*DOMWID,r = (hasFloor>=5)?DOMSPC-2*DOMWID:(2*DOMWID);
    /* we just draw towards the right - the cell on our left will deal
       with our connection to it if needed */
    glBegin(GL_QUADS);
    glColor3f(0,0.5f,1);
    glNormal3f(0,1,0);
    glVertex3f(l,-0.1f,-3);
    glVertex3f(l,-0.1f, 3);
    glVertex3f(r,-0.1f, 3);
    glVertex3f(r,-0.1f,-3);

    glNormal3f(0,0,1);
    glVertex3f(l,-0.1f,3);
    glVertex3f(l,-1.8f,3);
    glVertex3f(r,-1.8f,3);
    glVertex3f(r,-0.1f,3);

    glNormal3f(0,-1,0);
    glVertex3f(l,-1.8f,-3);
    glVertex3f(l,-1.8f, 3);
    glVertex3f(r,-1.8f, 3);
    glVertex3f(r,-1.8f,-3);
    if (hasFloor<5) {// right border
      glNormal3f(1,0,0);
      glVertex3f(r,-1.8f,-3);
      glVertex3f(r,-1.8f, 3);
      glVertex3f(r,-0.1f, 3);
      glVertex3f(r,-0.1f,-3);
    }

    if (! (hasFloor & 2)) {// left border
      glNormal3f(-1,0,0);
      glVertex3f(l,-0.1f,-3);
      glVertex3f(l,-0.1f, 3);
      glVertex3f(l,-1.8f, 3);
      glVertex3f(l,-1.8f,-3);
    }

    glEnd();
  }
  if (hasLadder) {
    glColor3f(1,1,1);
    glNormal3f(0,0,1);
    glBegin(GL_QUADS);
    glVertex3f(-1,0,3);
    glVertex3f(-0.9f,0,3);
    glVertex3f(-0.9f,CELLHEI,3);
    glVertex3f(-1,CELLHEI,3);

    glVertex3f(0.9f,0,3);
    glVertex3f(1,0,3);
    glVertex3f(1,CELLHEI,3);
    glVertex3f(0.9f,CELLHEI,3);

    for (int y=1;y<CELLHEI;y++) {
      glVertex3f(-1.1f,y,2.9f);
      glVertex3f(1.1f,y,2.9f);
      glVertex3f(1.1f,y+0.1f,2.9f);
      glVertex3f(-1.1f,y+0.1f,2.9f);
    }

    glEnd();
  }
}

bool Cell::enter(Domino *d,int top) {
  bool k=true;
//   printf("loading a domino into (%d,%d).",x,y);
  if (this->d[top]) {
    //     printf("(BOOM!)");
    this->d[top]->boom();
    // d->boom();
    k=false;
  } else this->d[top] = d;
//   printf("\n");
  return k;
}

void Cell::leave(int top) {
  this->d[top] = 0;
}

int Cell::getX() {
  return x;
}

int Cell::getY() {
  return y;
}

int Cell::getFloor() {
  return hasFloor;
}

bool Cell::getLadder() {
  return hasLadder;
}

void Cell::setFloor(int floor) {
  hasFloor = floor;
}

void Cell::putDoor(Door *door) {
  this-> door = door;
}

Door *Cell::getDoor() {
  return door;
}

Domino *Cell::getDomino(int top) {
  return d[top]?d[top]:&blank;
}
