#include "bridge.h"
#include "base.h"
#include "main.h"

Bridge::Bridge() {}

void Bridge::land() {
  int f = cell->getFloor();
  //  int g = cells[cell->getX()+speed][cell->getY()].getFloor();
  int h = level->getCell(cell->getX()+2*speed,cell->getY())->getFloor();
  if (speed && h) {
    level->getCell(cell->getX()+speed,cell->getY())->setFloor(7);

    // as soon as the bridger does something, it vanishes
    if (!(f & (3+speed))) cell->leave(top);
    cell->setFloor(f | (4+speed));
    level->getCell(cell->getX()+2*speed,cell->getY())->setFloor(h | (4-speed));
  }

  speed = 0;fly = 0;
}

void Bridge::render(float t) {
  /* process push()es */
  //  printf("%d + %d + %d\n",accel,speed,angle);
  if (accel!=0) speed=accel;
  accel=0;

  glPushMatrix();

  rot(t);

  if (renderBroken(t)) {

    int g=1; // green component

    glColor3f(1,1,0);
    glBegin(GL_QUADS);
    glNormal3f( 0,-1, 0);
    glVertex3f( -DOMWID,0, 2);
    glVertex3f( -DOMWID,0,-2);
    glVertex3f(  DOMWID,0,-2);
    glVertex3f(  DOMWID,0, 2);

    glColor3f(1,1,0);
    glNormal3f( 0,1,0);
    glVertex3f( -DOMWID,DOMHEI, -2);
    glVertex3f( -DOMWID,DOMHEI,  2);
    glVertex3f(  DOMWID,DOMHEI,  2);
    glVertex3f(  DOMWID,DOMHEI, -2);
    glEnd();

    glScalef(DOMWID,DOMHEI,1);
    float h=0.45f;
    for (int i=0;i<3;i++) {

      glColor3f(1,g,0);
      glBegin(GL_QUADS);
      glNormal3f( 0,0, 1);
      glVertex3f(-1,0, 2);
      glVertex3f(-1,h, 2);
      glVertex3f( 1,h, 2);
      glVertex3f( 1,0, 2);
      
      glNormal3f( 1,0, 0);
      glVertex3f( 1,0, 2);
      glVertex3f( 1,h, 2);
      glVertex3f( 1,h,-2);
      glVertex3f( 1,0,-2);
      
      glNormal3f( 0,0,-1);
      glVertex3f( 1,0,-2);
      glVertex3f( 1,h,-2);
      glVertex3f(-1,h,-2);
      glVertex3f(-1,0,-2);
      
      glNormal3f(-1,0, 0);
      glVertex3f(-1,0,-2);
      glVertex3f(-1,h,-2);
      glVertex3f(-1,h, 2);
      glVertex3f(-1,0, 2);
      glEnd();
      
      glTranslatef(0,h,0);
      g = 1-g;
      h = 0.55f-h;
    }
  }

  glPopMatrix();
}

Bridge::~Bridge() {

}


